/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.block.entity.SecurityStationBlockEntity;
import me.desht.pneumaticcraft.common.core.ModMenuTypes;
import me.desht.pneumaticcraft.common.hacking.secstation.HackSimulation;
import me.desht.pneumaticcraft.common.hacking.secstation.ISimulationController;
import me.desht.pneumaticcraft.common.hacking.secstation.SimulationController;
import me.desht.pneumaticcraft.common.inventory.AbstractPneumaticCraftMenu;
import me.desht.pneumaticcraft.common.inventory.slot.UntouchableSlot;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import org.apache.commons.lang3.tuple.Pair;

public class SecurityStationHackingMenu
extends AbstractPneumaticCraftMenu<SecurityStationBlockEntity> {
    public static final int NODE_SPACING = 31;

    public SecurityStationHackingMenu(int i, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(i, playerInventory, SecurityStationHackingMenu.fromBytes(playerInventory.f_35978_, buffer));
    }

    public SecurityStationHackingMenu(int windowId, Inventory playerInventory, BlockPos pos) {
        super((MenuType)ModMenuTypes.SECURITY_STATION_HACKING.get(), windowId, playerInventory, pos);
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 5; ++j) {
                UntouchableSlot slot = (UntouchableSlot)this.m_38897_((Slot)new UntouchableSlot(((SecurityStationBlockEntity)this.te).getPrimaryInventory(), j + i * 5, 8 + j * 31, 22 + i * 31));
                slot.setEnabled(slot.m_6657_());
            }
        }
    }

    private static BlockPos fromBytes(Player player, FriendlyByteBuf buffer) {
        BlockPos tilePos = buffer.m_130135_();
        HackSimulation playerSimulation = HackSimulation.readFromNetwork(buffer);
        HackSimulation aiSimulation = HackSimulation.readFromNetwork(buffer);
        ArrayList<Pair> nodes = new ArrayList<Pair>();
        int nNodes = buffer.m_130242_();
        for (int i = 0; i < nNodes; ++i) {
            nodes.add(Pair.of((Object)buffer.m_130242_(), (Object)buffer.m_130267_()));
        }
        boolean justTesting = buffer.readBoolean();
        return PneumaticCraftUtils.getTileEntityAt((BlockGetter)player.f_19853_, tilePos, SecurityStationBlockEntity.class).map(teSS -> {
            SimulationController controller = new SimulationController((SecurityStationBlockEntity)teSS, player, playerSimulation, aiSimulation, justTesting);
            nodes.forEach(node -> {
                controller.getSimulation(ISimulationController.HackingSide.PLAYER).addNode((Integer)node.getLeft(), (ItemStack)node.getRight());
                controller.getSimulation(ISimulationController.HackingSide.AI).addNode((Integer)node.getLeft(), (ItemStack)node.getRight());
            });
            teSS.setSimulationController(controller);
            return teSS.m_58899_();
        }).orElse(null);
    }

    @Override
    @Nonnull
    public ItemStack m_7648_(Player par1EntityPlayer, int par2) {
        return ItemStack.f_41583_;
    }
}

